/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import java.util.stream.Stream;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.block.entity.FermentationVesselBlockEntity;
import net.hecco.bountifulfares.block.enums.FermentationStage;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.hecco.bountifulfares.util.FermentationRecipes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FermentationVesselBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<FermentationStage> FERMENTATION_STAGE = EnumProperty.m_61587_((String)"fermentation_stage", FermentationStage.class);

    public FermentationVesselBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.EMPTY))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FERMENTATION_STAGE, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(FERMENTATION_STAGE) == FermentationStage.FERMENTING || state.m_61143_(FERMENTATION_STAGE) == FermentationStage.FERMENTED) {
            return Stream.of(Block.m_49796_((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), Block.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        }
        return Shapes.m_83113_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0), (VoxelShape)Block.m_49796_((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)15.0, (double)11.0), (BooleanOp)BooleanOp.f_82695_);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42589_) && PotionUtils.m_43579_((ItemStack)itemStack) == Potions.f_43599_ && state.m_61143_(FERMENTATION_STAGE) == FermentationStage.EMPTY) {
            world.m_7731_(pos, (BlockState)state.m_61124_(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.WATER)), 2);
            world.m_5594_(null, pos, BFSounds.FERMENTATION_VESSEL_FILL, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() / 3.0f);
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
            }
            if (itemStack.m_41619_() && !player.m_7500_()) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_42590_))) {
                player.m_36176_(new ItemStack((ItemLike)Items.f_42590_), false);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FermentationVesselBlockEntity) {
            FermentationVesselBlockEntity entity = (FermentationVesselBlockEntity)blockEntity;
            if (FermentationRecipes.isItemInput(player, hand) && state.m_61143_(FERMENTATION_STAGE) == FermentationStage.WATER) {
                if (entity.canInsertItem()) {
                    Item remainder;
                    entity.insertItem(itemStack.m_41720_().m_7968_());
                    world.m_46597_(pos, (BlockState)state.m_61124_(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.FERMENTING)));
                    FermentationVesselBlock.m_49897_((BlockState)((BlockState)state.m_61124_(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.WATER))), (BlockState)((BlockState)state.m_61124_(FERMENTATION_STAGE, (Comparable)((Object)FermentationStage.FERMENTING))), (LevelAccessor)world, (BlockPos)pos);
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(1);
                    }
                    if ((remainder = FermentationRecipes.getRemainderFromInput(player.m_21120_(hand).m_41720_())) != null) {
                        if (itemStack.m_41619_() && !player.m_7500_()) {
                            player.m_21008_(hand, new ItemStack((ItemLike)remainder));
                        } else if (!player.m_150109_().m_36054_(new ItemStack((ItemLike)remainder))) {
                            player.m_36176_(new ItemStack((ItemLike)remainder), false);
                        }
                    }
                    world.m_5594_(null, pos, BFSounds.FERMENTATION_VESSEL_SPLASH, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() / 3.0f);
                    return InteractionResult.SUCCESS;
                }
            } else if (!entity.canInsertItem()) {
                return entity.tryExtractItem(world, pos, state, player, hand);
            }
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        boolean bl = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)super.m_5573_(ctx).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(bl));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FermentationVesselBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return FermentationVesselBlock.m_152132_(type, BFBlockEntities.FERMENTATION_VESSEL_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> blockEntity.tick(world1, pos, state1));
    }
}

